#!/usr/bin/python3

import sys
from src_langdetect.langdetect.detector_factory import detect_langs, DetectorFactory
DetectorFactory.seed = 0

ACCEPTED_LANGS = {
    'cs': 'czech',
    'sk': 'slovak',
    'en': 'english',
}

for line in sys.stdin:
    line = line.strip()
    lang = None
    for lang_obj in detect_langs(line):
        lang = ACCEPTED_LANGS.get(lang_obj.lang)
        if lang:
            break
    if not lang:
        lang = 'unknown'
    sys.stdout.write('%s\t%s\n' % (lang, line))
